# Sciencéthic

# Programme de mesures pour loi de l'hydrostatique.
# Lecture d'un capteur de pression analogique sur le port A1.

# Le capteur de pression utilisé  Réf. 651 059: 0/+20 hPa (Sciencéthic)
# Le témoin LED de la carte Plug'Uno est utilisé (connecté a D13)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
#
brocheCapteurPression = plugUno.get_pin('a:1:i')
# -> a  : signifie mode analogique
# -> 1  : numéro de la broche
# -> i  : mode entrée
#
brocheLED = plugUno.get_pin('d:13:o')
# -> d  : signifie mode numerique/digital
# -> 13  : numéro de la broche
# -> o  : mode sortie/output

# Active le mécanisme de rapport d'état des E/S
plugUno.samplingOn()


################################
# Section mesures
################################
# Allume la LED pour indiquer que le programme est prêt...
# pour effectuer les mesures de préssion.
brocheLED.write(1)

# liste des mesures ADC et profondeurs saisit associé
mesure=[]
profondeur=[]

poursuite=True
while poursuite:
        
	# saisir et enregistrement de la profondeur dans la liste
	profondeur.append( float(input("Saisir profondeur en mètre : ")) )
	
	input("taper ENTER pour effectuer la mesure...")
	
	# ajout de la mesure dans la liste
	mesure.append( brocheCapteurPression.read() )

	# affichage de la mesure
	print("mesure : ", mesure[-1] )
	
	if input("nouvelle mesure oui/non ? ") == "non": poursuite=False

# Éteint la LED pour indiquer la fin des mesures.
brocheLED.write(0)
# fermeture de la communication sur le port
plugUno.exit()

# Affichage des résultats obtenu
print(
    "\n"      
    "Profondeurs : ",profondeur,
    "\n"
    "Mesures : ",mesure,
)


################################
# Section tracés (facultatif)
# matplotlib doit être installé
# numpy doit être installé
################################
print('----------------------------------')

if input('Voulez-vous effectuer un tracé de ces mesures (o/n) ?') != "non" :
        # importation de la bibliothèque pour le calcul de régression linéaire
	import numpy as np
	# bibliothèque de tracés
	import matplotlib.pyplot as plt
	
        # initialisation de la liste des pressions
	pression=[]

	
	for i in range(len(mesure)):
		pression.append(mesure[i]*7310-731)
		
	# régression linéaire
	regression = np.polyfit(profondeur, pression, 1)

	# initialisation de la fonction modèle linéaire
	f_reg=np.poly1d(regression)                         

        # tracé des valeurs expérimentales
	plt.plot(profondeur,pression,'+',label='mesures')

	# création des abcisses pour le tracé du modèle
	x=np.linspace(0,1.2*max(profondeur),50)

	# tracé du modèle
	plt.plot(x,f_reg(x),'-',color='r',label='régression linéaire')

	# titre de la figure
	plt.title('delta P=f(profondeur)')

	# paramétrage axe des abscisses entre 0 et 1,2*profondeur max
	plt.xlim(0, 1.2*max(profondeur))

	# paramétrage axe des ordonnées entre 0 et 1,2*pression max
	plt.ylim(0, 1.2*max(pression))

	# légendes des axes
	plt.xlabel('profondeur (m)')        
	plt.ylabel('delta P(Pa)')

	# paramétrages de la légende
	plt.legend(loc='lower right',fontsize=12)

	# tracé de la figure
	plt.show()                                



